package gov.va.vinci.dart.json.builder;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.json.DocumentTemplateView;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestDocumentTemplateViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		DocumentTemplateViewBuilder builder = new DocumentTemplateViewBuilder();
		
		try {
			builder.build(null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}
		
		DocumentTemplate dt = DartObjectFactory.getInstance().getDocumentTemplateDAO().findById(4);
		
		DocumentTemplateView dtv = builder.build(dt);
		Assert.assertEquals(dtv.getId(), 4);
		Assert.assertEquals(dtv.getSortOrder(), 9);
		Assert.assertEquals(dtv.getName(), "Research Request Memo");
		Assert.assertEquals(dtv.getDescription(), "Research Request Memo");
		Assert.assertEquals(dtv.getActivityType(), "activity type");  // weak sauce
		Assert.assertTrue(dtv.isParticipant());
		Assert.assertFalse(dtv.isPrincipalInvestigator());
		Assert.assertTrue(dtv.isAdministrator());
		
	}
}
